//
//  PITItemStore.m
//  PIT
//
//  Created by VA DEVELOPER on 11/24/12.
//  Copyright (c) 2012. All rights reserved.
//

#import "PITItemStore.h"
#import "PITItem.h"
#import "PITBackup.h"

@implementation PITItemStore


+ (PITItemStore *) sharedStore {
    static PITItemStore *sharedStore = nil;
    if (!sharedStore)
        sharedStore = [[super allocWithZone:nil]init];
    return sharedStore;
}

+ (id) allocWithZone:(NSZone *)zone {
    return [self sharedStore];
}



- (id) init {
    self = [super init];
    if (self) {
        NSString *path = [self itemArchivePath];
        allItems = [NSKeyedUnarchiver unarchiveObjectWithFile:path];
        
        if(!allItems)
            allItems = [[NSMutableArray alloc] init];
    }
    
    return self;
}

- (NSArray *) allItems {
    return allItems;
}

- (PITItem *) createItem {
    PITItem *p = nil;
    
    NSLog(@"PITItemStore: Default Location is Now: %@ City: %@ State: %@",
          [[NSUserDefaults standardUserDefaults] objectForKey:@"PITLocationCurrentFreePrefKey"],
          [[NSUserDefaults standardUserDefaults] objectForKey:@"PITLocationCurrentCityPrefKey"],
          [[NSUserDefaults standardUserDefaults] objectForKey:@"PITLocationCurrentStatePrefKey"]);
    
    if ([[NSUserDefaults standardUserDefaults] objectForKey:@"PITLocationCurrentFreePrefKey"] ||
        [[NSUserDefaults standardUserDefaults] objectForKey:@"PITLocationCurrentCityPrefKey"] ||
        [[NSUserDefaults standardUserDefaults] objectForKey:@"PITLocationCurrentStatePrefKey"]) {
        
        //initWithItemLocation: [[NSUserDefaults standardUserDefaults] objectForKey:@"PITLocationCurrentFreePrefKey"]
        p = [PITItem
             initWithItemLocation: @""
             itemCity: [[NSUserDefaults standardUserDefaults] objectForKey:@"PITLocationCurrentCityPrefKey"]
             itemState: [[NSUserDefaults standardUserDefaults] objectForKey:@"PITLocationCurrentStatePrefKey"]
             ];
    } else {
        p = [PITItem newItem];        
    }
    
    [allItems addObject: p];
    
    return p;
}

- (void) removeItem:(PITItem *)p {
    [allItems removeObjectIdenticalTo:p];
}

- (void) moveItemAtIndex:(int) from toIndex: (int)to {
    if (from == to) {
        return;
    }
    PITItem *p = [allItems objectAtIndex: from];
    [allItems removeObjectAtIndex: from];
    [allItems insertObject:p atIndex:to];
}

- (NSString *)itemArchivePath
{
    NSArray *documentDirectories =
        NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,
                                            NSUserDomainMask, YES);
 
       // Get one and only document directory from that list
    NSString *documentDirectory = [documentDirectories objectAtIndex:0];

    return [documentDirectory stringByAppendingPathComponent:@"items.archive"];
}

- (BOOL)saveChanges
{
    // returns success or failure
    NSString *path = [self itemArchivePath];
    
    if ([NSKeyedArchiver archiveRootObject:allItems toFile:path]) {
        [self protectFile:path];
        return TRUE;
    }
    
    return FALSE;
}

- (BOOL)backupChanges
{
    // Send pathBackup file
    /** POTENTIAL BACKUP CODE 
     
     
     
    NSError *error;
    
    NSLog(@"** Performing backup...");
    NSString *path = [self itemArchivePath];
    NSString *pathBackup = [path stringByAppendingString:@".backup"];
    
    NSLog(@"** Copying Archive...");
    // Copy File
    NSFileManager *fileManager = [NSFileManager defaultManager];
    [fileManager copyItemAtPath: path toPath: pathBackup error:&error];
    
    NSLog(@"** Protecting Copy...");    
    return[self protectFile:pathBackup];
    
    NSLog(@"** Url: %@", [[NSUserDefaults standardUserDefaults] objectForKey:@"PITBackupUrlPrefKey"]);
    
    if ([[[NSUserDefaults standardUserDefaults] objectForKey:@"PITBackupUrlPrefKey"] length] > 7) {
        NSLog(@"** Sending backup...");
        
        NSString *currentId = @"";
        if ([[[NSUserDefaults standardUserDefaults] objectForKey:@"PITBackupUrlIdPrefKey"] length] > 3) {
            NSLog(@"Identifier: %@", [[NSUserDefaults standardUserDefaults] objectForKey:@"PITBackupUrlIdPrefKey"]);
            currentId = [[NSUserDefaults standardUserDefaults] objectForKey:@"PITBackupUrlIdPrefKey"];
        } else {
            NSLog(@"No Identifier Found - Exiting");
            return FALSE;
        }
        
        NSDictionary *plist = [[NSDictionary alloc] initWithContentsOfFile:pathBackup];
        NSData *data = [NSPropertyListSerialization dataFromPropertyList:plist format:NSPropertyListXMLFormat_v1_0 errorDescription:nil];
        NSString* stringData = [[NSString alloc] initWithData:data encoding:NSUTF8StringEncoding];
        
        NSDictionary *itemPackage = [NSDictionary dictionaryWithObjectsAndKeys:
            currentId,@"uid",
            stringData,@"data",
            nil];
        
        [PITBackup sendEncoded:itemPackage toUrl:[[NSUserDefaults standardUserDefaults] objectForKey:@"PITBackupUrlPrefKey"]];
        return TRUE;
    } 
    */
    
//    return FALSE;
    NSString *sUrl = [NSString stringWithFormat:@"%@add", [[NSBundle mainBundle] objectForInfoDictionaryKey:@"PITWebServiceUrl"]];
    [PITBackup sendEncoded:nil toUrl:sUrl];

    return TRUE;
}

- (BOOL) protectFile: (NSString *) path {
    
    NSError *error;
    
    if ([NSKeyedArchiver archiveRootObject:allItems toFile:path]) {
        NSLog(@"Enabling File Protection");
        NSDictionary *fileAttributes = [NSDictionary dictionaryWithObject:NSFileProtectionComplete forKey:NSFileProtectionKey];
        
        if ([[NSFileManager defaultManager] setAttributes:fileAttributes ofItemAtPath:path error:&error]) {
            NSLog(@"File Protection: ON");
            return TRUE;
        } else {
            NSLog(@"File Protection Error! %@", error);
        }
    }
    
    
    return FALSE;
}


@end
